﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter_10
{
    struct Vector
    {
        private const int m_size = 4;
        private double[] m_vect;

        private void InitVector()
        {
            if (m_vect == null)
                m_vect = new double[m_size];
        }

        public double this[int index]
        {
            get 
            {
                InitVector();
                return m_vect[index]; 
            }
            set
            {
                InitVector();
                if (index < m_size)
                    m_vect[index] = value; 
            }
        }

        public static Vector operator +(Vector vect1, Vector vect2)
        {
            Vector vectSum = new Vector();

            for (int i = 0; i < m_size; i++)
            {
                vectSum[i] = vect1[i] + vect2[i];
            }

            return vectSum;
        }

        public override string ToString()
        {
            return string.Format(
                "X: {0}, Y: {1}, Z: {2}, Magnitude: {3}",
                m_vect[0], m_vect[1], m_vect[2], m_vect[3]);
        }
    }
}
